<?php

// Include your database connection configuration file
include_once 'config.php';

// Define the API URL and default response variables
$url = 'https://theglobalhub.site/mx/api';
$status = 2; // Default status
$msg = 'There are some mis-configurations. Please contact support.';
$resp = array('msg' => $msg, 'email' => 'you@email.com', 'status' => $status, 'url' => $url);

// Read JSON input data
$json = file_get_contents('php://input');
$obj = json_decode($json);

// Check if JSON input is empty
if (empty($obj)) {
    $resp = array('msg' => 'No data provided', 'status' => $status, 'url' => $url);
    echo json_encode($resp);
    exit();
} else {
    // Extract email and downloads from JSON object
    $email = $obj->email;
    $downloads = isset($obj->downloads) ? $obj->downloads : 0; // Default to 0 if not provided
    $ip = $_SERVER['REMOTE_ADDR']; // Get client's IP address

    // Fetch customer data from database based on email
    $query = "SELECT * FROM customers WHERE cust_email='" . $email . "'";
    $result = mysqli_query($link, $query);

    // Check if database query was successful
    if (!$result) {
        $msg = "MYSQL_ERROR:" . mysqli_error($link);
        $resp = array('msg' => $msg, 'status' => $status, 'url' => $url);
        echo json_encode($resp);
        exit();
    }

    // Check if customer with given email exists
    if (mysqli_num_rows($result) == 0) {
        $status = 0; // Customer not found status
        $msg = "Customer not found.";
    } else {
        // Fetch customer record
        $row = mysqli_fetch_assoc($result);

        // Check if IP is allowed
        $allowed_ips = explode(',', $row['allowed_ips']);
        if (!in_array($ip, $allowed_ips)) {
            $status = 2; // Unauthorized IP status
            $msg = "Unauthorized IP address.";
        } else {
            // Continue with other checks (activation status, download limits, etc.)
            if ($row['cust_status'] == 0) {
                $status = 2; // Blocked activation status
                $msg = "Your activation status is BLOCKED. Contact us for activation.";
            } else {
                // Example logic for download limit check
                if ($downloads > 0) {
                    if ($row['allowed_downloads'] > 0) {
                        if ($downloads > $row['current_downloads']) {
                            // Update current downloads in database
                            $newDownloads = $row['current_downloads'] + 1;
                            $updateQuery = "UPDATE customers SET current_downloads='$newDownloads' WHERE cust_email='$email'";
                            $updateResult = mysqli_query($link, $updateQuery);

                            if (!$updateResult) {
                                $msg = "Failed to update download count: " . mysqli_error($link);
                                $status = 2;
                            } else {
                                $status = 1; // Success status
                                $msg = "Download processed successfully.";
                            }
                        } else {
                            $status = 2; // Exceeded download limit status
                            $msg = "Your download limit has exceeded the allowed limits. Contact us to renew your package.";
                        }
                    } else {
                        $status = 2; // No download limit status
                        $msg = "Your download limit does not exist. Contact us to get a package.";
                    }
                } else {
                    $status = 2; // No downloads requested status
                    $msg = "No download count provided.";
                }
            }
        }
    }

    // Prepare response array and encode to JSON
    $resp = array('msg' => $msg, 'email' => $email, 'status' => $status, 'url' => $url);
    echo json_encode($resp);
}

?>
