<?php
include_once 'api/config.php';

// Check if the user is logged in
if (!isset($_SESSION['SESS_UID'])) {
    header('location:index.php');
    exit();
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Navigation -->
    <?php include_once 'includes/links.php'; ?>
    <!-- Navigation -->
</head>

<body>
    <!-- Navigation -->
    <?php $_POST['page'] = "Customers"; ?>
    <?php include_once 'includes/nav.php'; ?>
    <!-- Navigation -->

    <!-- Page Content -->
    <div class="container">
        <div class="row">
            <div class="col-lg-12 text-center">
                <h3 class="mt-5">Customers </h3>
                <p class="lead">Manage Customers</p>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12 " style="margin-bottom: 10px;">
                                <a data-fancybox data-type="ajax" data-src="add-customer.php" href="javascript:void();" class="btn btn-sm btn-primary float-right" style="font-size: 10px;"><i class="fas fa-edit"></i> Add Customer</a>
                            </div>
                        </div>
                        <?php 
                        $id=$_SESSION['SESS_UID'];
                        $sql="SELECT * FROM customers ";
                        $result = mysqli_query($link, $sql);
                        ?>

                        <?php if(isset($_SESSION['MSG'])){echo $_SESSION['MSG']; unset($_SESSION['MSG']);} ?>
                        <table class="table table-sm ">
                            <thead class="thead-dark">
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">NAME</th>
                                    <th scope="col">EMAIL</th>
                                    <th scope="col">EMAIL ALLOWED</th> <!-- Changed column name -->
                                    <th scope="col">EMAIL SENT</th>
                                    <th scope="col">DETAILS</th>
                                    <th scope="col">STATUS</th>
                                    <th scope="col">ACTIONS</th> <!-- Added column for actions -->
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=0; while ($row = mysqli_fetch_array($result)): ?>
                                    <tr>
                                        <td scope="row"><?=(++$i)?></td>
                                        <td><?=$row ["cust_name"]?></td>
                                        <td><?=$row ["cust_email"]?></td>
                                        <td><?=$row ["allowed_downloads"]?></td> <!-- Changed column name -->
                                        <td><?=$row ["current_downloads"]?></td>
                                        <td><?=$row ["cust_details"]?></td>
                                        <td><?=($row ["cust_status"]==0?" BLOCKED ":" ACTIVE ")?></td>
                                        <td>
                                            <a data-fancybox data-type="ajax" data-src="add-customer.php?editId=<?=$row['cust_id']?>" href="javascript:void();" style="font-size: 10px;" class="btn btn-sm btn-primary" >Edit</a>
                                            <a data-fancybox data-type="ajax" data-src="delete-customer.php?deleteId=<?=$row['cust_id']?>" href="javascript:void();" style="font-size: 10px;" class="btn btn-sm btn-danger" >Delete</a> <!-- Added delete button -->
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                                <?php if ($i==0): ?>
                                    <tr><td colspan="8"> No Record found.</td></tr>
                                <?php endif ?> 
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript -->
    <script src="assets/jquery/jquery.min.js"></script>
    <script src="assets/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript" src="assets/fancybox/jquery.fancybox.min.js"></script>
    <script>
        $(document).ready(function() {
            //$('a[class*=fancybox]').fancybox();
        });
    </script>
</body>

</html>
